/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.hardware.bus.Bus;
import emulator.hardware.bus.VicBus;
import emulator.shell.GUI.windows.ManagedWindow;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class WindowConfiguration
implements ActionListener {
    private static final int BLOCK_BUTTON_FACTOR = 10;
    private int window_id;
    private WindowManager window_manager;
    private VicBus bus;
    private JRadioButton[] empty_checks = new JRadioButton[5];
    private JRadioButton[] rom_checks = new JRadioButton[5];
    private JRadioButton[] ram_checks = new JRadioButton[5];

    public WindowConfiguration(WindowManager window_manager, int window_id, Bus bus) {
        this.window_manager = window_manager;
        this.window_id = window_id;
        this.bus = (VicBus)bus;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.window_manager.isWindowActive(this.window_id)) {
            this.closeWindow();
        } else {
            this.openWindow();
        }
    }

    private void openWindow() {
        ManagedWindow window = this.window_manager.createWindow(this.window_id, "Configuration");
        this.initDialog(window);
        this.initButtonStates();
        window.restorePosition();
        window.setVisible(true);
    }

    private void closeWindow() {
        this.window_manager.closeWindow(this.window_id);
    }

    private void initDialog(ManagedWindow window) {
        JLabel label_title = new JLabel("Memory configuration");
        JLabel label_empty = new JLabel("Empty");
        JLabel label_rom = new JLabel("ROM");
        JLabel label_ram = new JLabel("RAM");
        JLabel[] labels = new JLabel[]{new JLabel("3k: 0400-0FFF"), new JLabel("8k: 2000-3FFF"), new JLabel("8k: 4000-5FFF"), new JLabel("8k: 6000-7FFF"), new JLabel("8k: A000-BFFF")};
        int i = 0;
        while (i < 5) {
            this.empty_checks[i] = new JRadioButton();
            this.empty_checks[i].setActionCommand(new Integer(i * 10).toString());
            this.empty_checks[i].addActionListener(new RadioButtonListener());
            this.rom_checks[i] = new JRadioButton();
            this.rom_checks[i].setActionCommand(new Integer(i * 10 + 1).toString());
            this.rom_checks[i].addActionListener(new RadioButtonListener());
            this.ram_checks[i] = new JRadioButton();
            this.ram_checks[i].setActionCommand(new Integer(i * 10 + 2).toString());
            this.ram_checks[i].addActionListener(new RadioButtonListener());
            ButtonGroup button_group = new ButtonGroup();
            button_group.add(this.empty_checks[i]);
            button_group.add(this.rom_checks[i]);
            button_group.add(this.ram_checks[i]);
            ++i;
        }
        Container panel = window.getContentPane();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label_title).addGroup(layout.createSequentialGroup().addGroup(this.createLabelColumn(labels, layout)).addGroup(this.createButtonColumn(label_empty, this.empty_checks, layout)).addGroup(this.createButtonColumn(label_rom, this.rom_checks, layout)).addGroup(this.createButtonColumn(label_ram, this.ram_checks, layout))));
        GroupLayout.SequentialGroup vertical_group = layout.createSequentialGroup().addComponent(label_title).addGroup(layout.createParallelGroup().addComponent(label_empty).addComponent(label_rom).addComponent(label_ram));
        int i2 = 0;
        while (i2 < labels.length) {
            vertical_group.addGroup(this.createMemoryRow(i2, labels[i2], layout));
            ++i2;
        }
        layout.setVerticalGroup(vertical_group);
        layout.linkSize(0, label_empty, label_rom, label_ram);
    }

    private GroupLayout.Group createMemoryRow(int i, JLabel label, GroupLayout layout) {
        GroupLayout.ParallelGroup group = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        group.addComponent(label);
        group.addComponent(this.empty_checks[i]);
        group.addComponent(this.rom_checks[i]);
        group.addComponent(this.ram_checks[i]);
        return group;
    }

    private GroupLayout.Group createLabelColumn(JLabel[] labels, GroupLayout layout) {
        GroupLayout.ParallelGroup group = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        int i = 0;
        while (i < labels.length) {
            group.addComponent(labels[i]);
            ++i;
        }
        return group;
    }

    private GroupLayout.Group createButtonColumn(JLabel label, JRadioButton[] boxes, GroupLayout layout) {
        GroupLayout.ParallelGroup group = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        group.addComponent(label);
        int i = 0;
        while (i < boxes.length) {
            group.addComponent(boxes[i]);
            ++i;
        }
        return group;
    }

    private void initButtonStates() {
        this.initButtons(0, this.bus.getBlock3k());
        this.initButtons(1, this.bus.getBlock0());
        this.initButtons(2, this.bus.getBlock1());
        this.initButtons(3, this.bus.getBlock2());
        this.initButtons(4, this.bus.getBlock3());
    }

    private void initButtons(int i, int block_state) {
        switch (block_state) {
            case 0: {
                this.empty_checks[i].setSelected(true);
                break;
            }
            case 1: {
                this.rom_checks[i].setSelected(true);
                break;
            }
            case 2: {
                this.ram_checks[i].setSelected(true);
            }
        }
    }

    class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int hint = Integer.decode(e.getActionCommand());
            int block_no = hint / 10;
            int block_state = hint % 10;
            switch (block_no) {
                case 0: {
                    WindowConfiguration.this.bus.setBlock3k(block_state);
                    break;
                }
                case 1: {
                    WindowConfiguration.this.bus.setBlock0(block_state);
                    break;
                }
                case 2: {
                    WindowConfiguration.this.bus.setBlock1(block_state);
                    break;
                }
                case 3: {
                    WindowConfiguration.this.bus.setBlock2(block_state);
                    break;
                }
                case 4: {
                    WindowConfiguration.this.bus.setBlock3(block_state);
                }
            }
        }
    }
}

